<!DOCTYPE html>
<?php
include('header.php');

$pdf_preview = '';
$show_preview = false;

if (isset($_POST['find'])) {
    $rc_no = mysqli_real_escape_string($ahk_conn, $_POST['rc_dl']);
    $type = mysqli_real_escape_string($ahk_conn, $_POST['type']);
    $cardtype = mysqli_real_escape_string($ahk_conn, $_POST['cardtype']);

    $price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='rc_vehical_fee'"));
    $fee = $price['price'];
    $username = $udata['phone'];
    $wallet_amount = $udata['balance'];
    $debit_fee = $wallet_amount - $fee;

    if ($wallet_amount > $fee) {
        $api_key = urlencode($flexsecure_key);
        $url = "https://" . htmlspecialchars($flexsecureapiurl) . "/serviceApi/V3/rc_link.php?apiKey=$api_key&rcno=$rc_no&type=$type&cardtype=$cardtype";

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);
        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response, true);
        $statusMessage = $result['statusMessage'] ?? '';
        $check_code = $result['status'] ?? '';
        $MSG = $result['message'] ?? '';
        $file = isset($result['pdf']) ? "data:application/pdf;base64," . $result['pdf'] : '';

        if (!$file || $check_code != "200") {
            echo "<script>
                    Swal.fire(
                        '{$MSG}',
                        'Try Server S1',
                        'warning'
                    );
                  </script>";
        } else {
            mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $fee WHERE phone = '$username'");
            date_default_timezone_set("Asia/Kolkata");
            $time_hkb = date('d/m/Y g:i:s');

            mysqli_query($ahk_conn, "INSERT INTO rc_vehical (username, rc_vehical_no, status, pdf, date) VALUES ('$username','$rc_no','$MSG','$file','$time_hkb')");
            mysqli_query($ahk_conn, "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type) VALUES ('$username','$fee','$debit_fee','RC Vehical PDF','1','Debit')");

            $pdf_preview = $file;
            $show_preview = true;

            echo "<script>
                    Swal.fire(
                        'Download Successful: RC {$rc_no}',
                        'PDF Generated Successfully',
                        'success'
                    );
                  </script>";
        }
    } else {
        echo "<script>
                Swal.fire(
                    'Oops',
                    'Wallet Balance Insufficient! Please Recharge',
                    'error'
                );
              </script>";
    }
}
?>

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb with Action Buttons -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Rc Pdf Server S2</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="rc_get_list" class="btn btn-success">
                    <i class="bi bi-list-ul me-1"></i> RC Pdf List
                </a>
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>

    <div class="container-fluid pt-4 px-4">
      <div class="row">
        <!-- Form Section -->
        <div class="col-lg-5 mb-4">
          <div class="card">
            <div class="card-body">
              <div class="p-3 mb-4 rounded text-white" style="background: linear-gradient(135deg, #0062E6, #33AEFF);">
                <h3 class="text-center m-0 text-white">
                  <i class="bi bi-file-earmark-pdf-fill me-2"></i>
                  <strong>RC Owner Book PDF Download Instant</strong>
                </h3>
              </div>
            </div>
            <form action="" method="post" id="Job_print">
              <div class="card-body">
                <div class="form-group">
                  <label for="rc_dl" class="card-title">Enter Vehicle Number</label>
                  <input type="text" name="rc_dl" id="rc_dl" class="form-control" required placeholder="BH01XX1454" oninput="removeSpaces(this)">
                </div>
                <div class="form-group mt-3">
                  <label for="type" class="card-title">Chip Type</label>
                  <select name="type" class="form-control">
                    <option value="2">Without Chip</option>
                    <option value="1">With Chip</option>
                  </select>
                </div>
                <div class="form-group mt-3">
                  <label for="cardtype" class="card-title">Card Type</label>
                  <select name="cardtype" class="form-control">
                    <option value="2">New Version</option>
                    <option value="1">Old Version</option>
                  </select>
                </div>
              </div>
              <div class="text-center mb-3">
                <button type="submit" name="find" class="btn btn-success btn-block">
                  <i class="fa fa-check-circle"></i> Submit
                </button>
              </div>
              <div class="col-12 d-flex justify-content-center">
                <div class="fee-container text-center">
                 <h5 class="text-warning">Application Fee: 
            <?php  
                $price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT price FROM pricing WHERE service_name='rc_vehical_fee'")); 
                echo "₹" . $price['price'];
            ?>
        </h5>
                </div>
              </div>
            </form>
          </div>
        </div>

        <!-- PDF Preview Section -->
        <div class="col-lg-7 mb-4">
          <div class="card h-100">
            <div class="card-header bg-info text-white">
              <h5 class="mb-0"><i class="bi bi-eye-fill me-2"></i>PDF Preview</h5>
            </div>
            <div class="card-body text-center">
              <?php if ($show_preview && !empty($pdf_preview)): ?>
                <embed src="<?php echo $pdf_preview; ?>" width="100%" height="500px" type="application/pdf">
                <div class="mt-3">
                  <a href="<?php echo $pdf_preview; ?>" download="RC_PDF_<?php echo $rc_no; ?>.pdf" class="btn btn-success">
                    <i class="bi bi-download"></i> Download PDF
                  </a>
                </div>
              <?php else: ?>
                <p class="text-muted mt-4">No preview available. Submit a valid vehicle number to view the RC PDF.</p>
              <?php endif; ?>
              <!-- New Buttons -->
              <div class="mt-4">
    <p class="text-danger"><strong>Note:</strong> If any issue occurs, try Server Two or Three.</p>

    <a href="rc_get" class="btn btn-primary me-2">Try Server One</a>
    <a href="rc_get_father" class="btn btn-primary me-2">Try Father Server Three</a>
    <small class="text-danger d-block mt-1">*Use this if Father Name is missing or incorrect*</small>

    <a href="rc_get_list" class="btn btn-secondary mt-2">PDF List</a>
</div>

            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<style>
  .fee-container {
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    padding: 10px 15px;
    max-width: 300px;
    width: 100%;
    margin-top: 10px;
  }
  .fee-container h5 {
    color: #ff9800;
    font-size: 18px;
    font-weight: 600;
    margin: 0;
  }
</style>


<!-- JS -->
<script>
function removeSpaces(input) {
    input.value = input.value.replace(/\s/g, "");
}
</script>


<?php include("footer.php");?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
		$(document).ready(function() {
			$('#example').DataTable();
		  } );
	</script>
	
	<script>
		$(document).ready(function() {
			var table = $('#example2').DataTable( {
				lengthChange: false,
				buttons: [ 'copy', 'excel', 'pdf', 'print']
			} );
		 
			table.buttons().container()
				.appendTo( '#example2_wrapper .col-md-6:eq(0)' );
		} );
	</script>
	
</body>



</html>